// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the ELOPUBLICINTERFACE_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// ELOPUBLICINTERFACE_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef ELOPUBLICINTERFACE_EXPORTS
#define ELOPUBLICINTERFACE_API __declspec(dllexport)
#else
#define ELOPUBLICINTERFACE_API __declspec(dllimport)
#endif

// -----------------------------------------------------------------------------
// Elo Software Development Kit 
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// Constants
// -----------------------------------------------------------------------------
//valid touch modes
#define CLICK_ON_TOUCH		0
#define CLICK_ON_RELEASE	1
#define	MOUSE_EMULATION		6

#define TOUCHSCREEN_TYPE_USB 0x01
#define TOUCHSCREEN_TYPE_PNP_SERIAL 0x02
#define TOUCHSCREEN_TYPE_NTSERIAL 0x04
#define TOUCHSCREEN_TYPE_LEGACYSERIAL 0x08

#define WM_ELOSWAPBUTTON WM_USER+4698

#define MAX_SUPPORTED_SCR			32

#define COMPORT_NAME_LENGTH			256
#define SERIALNUMBER_NAME_LENGTH	18

#ifndef ELOPUBLICINTERFACE_EXPORTS
// -----------------------------------------------------------------------------
typedef enum _CONTRL_STAT				// ctrl_status values
{
	CS_OK = 0,
	CS_ConstantTouch,
	CS_CanNotFindController,
	CS_NoResponse,
	CS_InvalidResponse,
	CS_CanNotSetBaudRate,
	CS_CommandNotSent,
	CS_SystemError,
	CS_InvalidCommPort,
	CS_CommPortFailedOpen,
	CS_CommPortCommandError,
	CS_CommPortNoController,
	CS_UndefinedController
} CONTRL_STAT;

// -----------------------------------------------------------------------------
typedef enum _GETPOINTS_STATUS	
{
	InitialTouch=1,
	StreamTouch = 2,
	UnTouch =4
}GETPOINTS_STATUS ;

// -----------------------------------------------------------------------------
typedef enum _GETPOINTS_CODE	
{
	ReturnImmediately=1,
 	ReturnOnTouch,
 	ReturnOnUntouch,
 	ReturnOnNextValidTouch
}GETPOINTS_CODE ;

// -----------------------------------------------------------------------------
typedef enum 
{
	TempWrite = 1,	// dont write to registry	
	Write,			// write to registry
} RegistryOperation;

#endif


// -----------------------------------------------------------------------------
// Structure definitions
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// Screen Properties
typedef struct _SCREEN_PROPERTIES
{
	int		iWindowsMonNo ;
	ULONG	Type;	
	char	Port[COMPORT_NAME_LENGTH];
	char	SerialNumber[SERIALNUMBER_NAME_LENGTH];	
	DWORD   HardwareHandshaking ; 
	CONTRL_STAT		ctrl_status;	
	LONG			BaudRate;		
	char			crevminor;		
	char			crevmajor;		
	char			trevminor;		
	char			trevmajor;		
	char			diagcodes[8];	
	char			id[8];			
	char			cnt_id[8];		
	char			driver_id[32];	
}SCREEN_PROPERTIES, *PSCREEN_PROPERTIES ;

// -----------------------------------------------------------------------------
// Defines a touch coordinate buffer
typedef struct _TOUCH_POINT
{
	LONG				x;
	LONG				y;
	LONG				z;
	GETPOINTS_STATUS	Status;		
}TOUCH_POINT, *PTOUCH_POINT ;

// -----------------------------------------------------------------------------
// dragdelay data
typedef struct _Drag_Delay{
	DWORD MinDragDelay ;
	DWORD MaxDragDelay ;
	DWORD DragDelay ;
} DRAG_DELAY, *PDRAG_DELAY ;

// -----------------------------------------------------------------------------
// Beep Data
typedef struct _Beep{
	BOOL BeepFlag;
	DWORD BeepFreq ;
	DWORD BeepTime ;
} BEEP, *PBEEP ;

#ifndef ELOPUBLICINTERFACE_EXPORTS
// -----------------------------------------------------------------------------
// Defines touch boundary rectangle
typedef struct _ClippingBounds		
{
	ULONG			X_Max;
	ULONG			X_Min;
	ULONG			Y_Max;
	ULONG			Y_Min;
	ULONG			Z_Max;
	ULONG			Z_Min;
} ClippingBounds, *PClippingBounds;
#endif
// -----------------------------------------------------------------------------
// touch boundary data
typedef struct _Touch_Boundary
{
	ClippingBounds	Bounds;
	LONG			ClippingMode;
} TOUCH_BOUNDARY, *PTOUCH_BOUNDARY ;


// -----------------------------------------------------------------------------
// Defines calibration data input buffer. Initialise this buffer to set calibration 
// data to driver.
typedef struct _Calibration		
{
	LONG	VDeskMode ;
	LONG	nScrDx ;
	LONG	nEloDx ;
	LONG	nOffsetX ;
	LONG	nScrDy ;
	LONG	nEloDy ;
	LONG	nOffsetY ;
	LONG	xyswap;				
	LONG	MonitorNumber ;
	RegistryOperation	CalMode ;
	LONG	xRes ;		// x, y monitor resolution at which these calculations were made
	LONG	yRes ;
	LONG	xVirtScrSize ;	// Width and height, in pixels, of the virtual screen. 
	LONG	yVirtScrSize ;	// The virtual screen is the bounding rectangle of all display monitors.
	LONG	xVirtScrCoord ;	// Coordinates for the left side and the top of the virtual screen. 
	LONG	yVirtScrCoord ;	
	LONG	xMonLocn ;		// monitor location
	LONG	yMonLocn ;

	// Added to support higher-order calibration models
	LONG	xCoefficients[40];	// 25-point X correction coefficients
	LONG	yCoefficients[40];	// 25-point Y correction coefficients
	LONG	ModelType;			// Model type for advanced fit model
	LONG	ModelRotation;		// Rotation obtained from new model calculations
	LONG	xModelOffset;		// Offset obtained from new model calculations
	LONG	yModelOffset;		// Offset obtained from new model calculations
	LONG	ModelOrder;
	LONG	ControllerOffset  ;
	LONG	ScaleDivisor  ;
	LONG	MiniTgtDeltaX[11];
	LONG	MiniTgtDeltaY[11];
	LONG	MiniTgtTargetX[11];
	LONG	MiniTgtTargetY[11];
	LONG	CalibrateDelta[11];
	LONG	InterTargetDistance[11][11];
	LONG	Reserved[10];
} CALIBRATION, *PCALIBRATION;

// -----------------------------------------------------------------------------
// Quick Touch data
typedef struct _Quick_Touch
{
	DWORD			bEnable ;		
	ULONG			Dx ;
	ULONG			Dy ;
} QUICK_TOUCH, *PQUICK_TOUCH;

// -----------------------------------------------------------------------------
// Edge acceleration data

// -----------------------------------------------------------------------------
typedef struct _Accel
{
	ULONG			Enable;
	ULONG			Scale;
	ClippingBounds	Bounds[1];
} EDGE_ACCEL, *PEDGE_ACCEL ;


// -----------------------------------------------------------------------------
// Untouch timeout
typedef struct _UNTOUCH_TIMEOUT
{
	ULONG			TimeOut;
	ULONG			Width;
	ULONG			Height;
}UNTOUCH_TIMEOUT, *PUNTOUCH_TIMEOUT ; 
// -----------------------------------------------------------------------------
// Right button on hold 
typedef struct _Right_Button
{
	DWORD			RightClickHW ;
	DWORD			InitialTimeout ;
	DWORD			DefaultRightClickDelay ;
	DWORD			MaxRightClickDelay ;
	DWORD			MinRightClickDelay ; 
	ULONG			ClickCount;
	ULONG			Active ;
}RIGHT_BUTTON, *PRIGHT_BUTTON;

// 04-15-2008: struct represents the 3-pt calibration data stored in NVRam
typedef struct _NVRam_Cal_Data
{
	DWORD dwEDID; // 4-byte serial number in monitor's EDID (Extended Display Identification Data)

	int nEloDx;   
	int nEloDy;
	int nScreenDx;
	int nScreenDy;
	int nOffsetX;
	int nOffsetY;
	BOOL bSwapXY;
} NVRAM_CAL_DATA;

// -----------------------------------------------------------------------------
// Structures used by Smartset 
typedef struct _Smartset_Data
{
	LONG ScreenNumber;
	union
	{
		char Command[8];
		USHORT Response;
	};
} SMARTSET_DATA;

// -----------------------------------------------------------------------------
// API function calls 
// -----------------------------------------------------------------------------

// -----------------------------------------------------------------------------
// This is the first call required to be made to enumerate & initialise the touch 
// screens. It returns the total number of screens found.
//
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetScreenInfo(DWORD dwMonNo[MAX_SUPPORTED_SCR], int &iScrCnt);
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
//
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetTouch(PTOUCH_POINT tpxy, BOOL xlated, 
									   GETPOINTS_CODE getCode, UINT &nScrNo);
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloCancel() ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetMouseMode( WORD *pwMode , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetMouseMode( WORD wMode , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetTouchReportingState( BOOL *pbFlag , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetTouchReportingState( BOOL bFlag , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetDragDelay( PDRAG_DELAY pDragDelay , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetDragDelay( PDRAG_DELAY pDragDelay , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetBeep( PBEEP psndVal , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetBeep( PBEEP psndVal , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetTouchBoundary( PTOUCH_BOUNDARY ptBndry , UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetTouchBoundary( PTOUCH_BOUNDARY ptBndry , UINT nScrNo );
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetCalibrationData( PCALIBRATION pCalData , UINT nScrNum ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetCalibrationData( PCALIBRATION pCalData, UINT nScrNum ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSwapButton( HWND hWnd, DWORD dwCnt, UINT nScrNum );
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetLeftHandedMouse( BOOL bFlag ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetDiagnosticsData( PSCREEN_PROPERTIES pData, UINT nScrNo );
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetQuickTouch( PQUICK_TOUCH pQTouch, UINT nScrNo );
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetQuickTouch( PQUICK_TOUCH pQTouch, UINT nScrNo );
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetEdgeAccel( PEDGE_ACCEL pAccel, UINT nScrNo );
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetEdgeAccel( PEDGE_ACCEL pAccel, UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetUntouchTimeout( PUNTOUCH_TIMEOUT pUTimeout, UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetUntouchTimeout( PUNTOUCH_TIMEOUT pUTimeout, UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetRightClickOnHold( PRIGHT_BUTTON pRBHold, UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSetRightClickOnHold( PRIGHT_BUTTON pRBHold, UINT nScrNo ) ;
#ifdef __cplusplus
}
#endif

// AIA: Smartset stuff For Debug use.
// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetNVRamCalData (NVRAM_CAL_DATA *pNVRamCalData, UINT nScrNo);
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int Elo (SMARTSET_DATA* pSmartsetData);
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloSendSmartsetCommand (SMARTSET_DATA* pSmartsetData);
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetSmartsetResponseStatus (SMARTSET_DATA* pSmartsetData);
#ifdef __cplusplus
}
#endif

// -----------------------------------------------------------------------------
#ifdef __cplusplus
extern "C" {
#endif  
ELOPUBLICINTERFACE_API int EloGetSmartsetResponse (SMARTSET_DATA* pSmartsetData);
#ifdef __cplusplus
}
#endif
